/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.NpcMiscInventory;
import noppes.npcs.containers.ContainerNPCBank;
import noppes.npcs.controllers.data.Bank;
import noppes.npcs.controllers.data.BankData;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.util.Util;

public class BankController {
    private static BankController instance;
    public HashMap<Integer, Bank> banks;
    private String filePath = "";

    public static BankController getInstance() {
        if (BankController.newInstance()) {
            instance = new BankController();
        }
        return instance;
    }

    private static boolean newInstance() {
        if (instance == null) {
            return true;
        }
        File file = CustomNpcs.getWorldSaveDirectory();
        return file != null && !BankController.instance.filePath.equals(file.getAbsolutePath());
    }

    public BankController() {
        instance = this;
        this.banks = new HashMap();
        this.loadBanks();
        if (this.banks.isEmpty()) {
            Bank bank = new Bank();
            bank.id = 0;
            bank.name = "Default Bank";
            this.banks.put(bank.id, bank);
        }
    }

    public void change(Bank bank) {
        Object player;
        if (bank == null || !this.banks.containsKey(bank.id) || CustomNpcs.Server == null) {
            return;
        }
        for (String username : CustomNpcs.Server.func_71213_z()) {
            player = CustomNpcs.Server.func_184103_al().func_152612_a(username);
            PlayerData data = PlayerData.get((EntityPlayer)player);
            if (player != null && ((EntityPlayerMP)player).field_71070_bA instanceof ContainerNPCBank && ((ContainerNPCBank)((EntityPlayerMP)player).field_71070_bA).bank.id == bank.id) {
                player.func_71128_l();
                player.func_145747_a((ITextComponent)new TextComponentTranslation("message.bank.changed", new Object[0]));
            }
            if (data.bankData.lastBank == null || data.bankData.lastBank.bank.id != bank.id) continue;
            data.bankData.lastBank = null;
        }
        if (bank.isPublic) {
            File banksDir = CustomNpcs.getWorldSaveDirectory("banks");
            File fileBank = new File(banksDir, bank.id + ".dat");
            BankData bd = new BankData(bank, "");
            try {
                bd.readNBT(CompressedStreamTools.func_74796_a((InputStream)Files.newInputStream(fileBank.toPath(), new OpenOption[0])));
            }
            catch (IOException e) {
                LogWriter.error(e);
            }
            boolean isChange = false;
            player = bd.cells.keySet().iterator();
            while (player.hasNext()) {
                int c = (Integer)player.next();
                if (!bank.ceilSettings.containsKey(c)) {
                    isChange = true;
                    break;
                }
                NpcMiscInventory inv = bd.cells.get(c);
                Bank.CeilSettings cs = bank.ceilSettings.get(c);
                if (inv.func_70302_i_() < cs.startCells) {
                    bd.cells.put(c, new NpcMiscInventory(cs.openStack.func_190926_b() ? cs.startCells : 0).fill(inv));
                    isChange = true;
                    continue;
                }
                if (inv.func_70302_i_() <= cs.maxCells) continue;
                bd.cells.put(c, new NpcMiscInventory(cs.maxCells).fill(inv));
                isChange = true;
            }
            if (isChange) {
                try {
                    CompressedStreamTools.func_74799_a((NBTTagCompound)bd.getNBT(), (OutputStream)Files.newOutputStream(fileBank.toPath(), new OpenOption[0]));
                }
                catch (Exception e) {
                    LogWriter.error(e);
                }
            }
        } else {
            File datasDir = CustomNpcs.getWorldSaveDirectory("playerdata");
            if (datasDir == null) {
                return;
            }
            for (File playerDir : Objects.requireNonNull(datasDir.listFiles())) {
                if (!playerDir.isDirectory()) continue;
                for (File banksDir : Objects.requireNonNull(playerDir.listFiles())) {
                    File fileBank;
                    if (!banksDir.isDirectory() || !banksDir.getName().equals("banks") || !(fileBank = new File(banksDir, bank.id + ".dat")).exists()) continue;
                    BankData bd = new BankData(bank, "");
                    try {
                        bd.readNBT(CompressedStreamTools.func_74796_a((InputStream)Files.newInputStream(fileBank.toPath(), new OpenOption[0])));
                    }
                    catch (IOException e) {
                        LogWriter.error(e);
                    }
                    boolean isChange = false;
                    for (int c : bd.cells.keySet()) {
                        if (!bank.ceilSettings.containsKey(c)) {
                            isChange = true;
                            bd.cells.remove(c);
                            continue;
                        }
                        NpcMiscInventory inv = bd.cells.get(c);
                        Bank.CeilSettings cs = bank.ceilSettings.get(c);
                        if (inv.func_70302_i_() < cs.startCells) {
                            bd.cells.put(c, new NpcMiscInventory(cs.openStack.func_190926_b() ? cs.startCells : 0).fill(inv));
                            isChange = true;
                            continue;
                        }
                        if (inv.func_70302_i_() <= cs.maxCells) continue;
                        bd.cells.put(c, new NpcMiscInventory(cs.maxCells).fill(inv));
                        isChange = true;
                    }
                    if (!isChange) continue;
                    try {
                        CompressedStreamTools.func_74799_a((NBTTagCompound)bd.getNBT(), (OutputStream)Files.newOutputStream(fileBank.toPath(), new OpenOption[0]));
                    }
                    catch (Exception e) {
                        LogWriter.error(e);
                    }
                }
            }
        }
    }

    public Bank getBank(int bankId) {
        if (this.banks.containsKey(bankId)) {
            return this.banks.get(bankId);
        }
        for (Bank bank : this.banks.values()) {
            if (bank.id != bankId) continue;
            return bank;
        }
        return null;
    }

    public NBTTagCompound getNBT() {
        NBTTagList list = new NBTTagList();
        for (Bank bank : this.banks.values()) {
            NBTTagCompound nbtfactions = new NBTTagCompound();
            bank.writeToNBT(nbtfactions);
            list.func_74742_a((NBTBase)nbtfactions);
        }
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.func_74782_a("Data", (NBTBase)list);
        return nbttagcompound;
    }

    public int getUnusedId() {
        int id = 0;
        while (this.banks.containsKey(id)) {
            ++id;
        }
        return id;
    }

    private void loadBanks() {
        CustomNpcs.debugData.start(null);
        File saveDir = CustomNpcs.getWorldSaveDirectory();
        if (saveDir == null) {
            CustomNpcs.debugData.end(null);
            return;
        }
        this.filePath = saveDir.getAbsolutePath();
        try {
            File file = new File(saveDir, "bank.dat");
            if (file.exists()) {
                this.loadBanks(file);
            }
        }
        catch (Exception e) {
            try {
                File file2 = new File(saveDir, "bank.dat_old");
                if (file2.exists()) {
                    this.loadBanks(file2);
                }
            }
            catch (Exception ex) {
                LogWriter.error(ex);
            }
        }
        CustomNpcs.debugData.end(null);
    }

    private void loadBanks(File file) throws IOException {
        this.loadBanks(CompressedStreamTools.func_74796_a((InputStream)Files.newInputStream(file.toPath(), new OpenOption[0])));
    }

    public void loadBanks(NBTTagCompound compound) {
        HashMap<Integer, Bank> banks = new HashMap<Integer, Bank>();
        NBTTagList list = compound.func_150295_c("Data", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbtBank = list.func_150305_b(i);
            Bank bank = new Bank();
            bank.readFromNBT(nbtBank);
            banks.put(bank.id, bank);
        }
        this.banks = banks;
    }

    public void removeBank(int bankId) {
        if (!this.banks.containsKey(bankId)) {
            return;
        }
        if (CustomNpcs.Server != null) {
            for (String username : CustomNpcs.Server.func_71213_z()) {
                EntityPlayerMP player = CustomNpcs.Server.func_184103_al().func_152612_a(username);
                PlayerData data = PlayerData.get((EntityPlayer)player);
                if (player != null && player.field_71070_bA instanceof ContainerNPCBank && ((ContainerNPCBank)player.field_71070_bA).bank.id == bankId) {
                    player.func_71128_l();
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("message.bank.changed", new Object[0]));
                }
                if (data.bankData.lastBank == null || data.bankData.lastBank.bank.id != bankId) continue;
                data.bankData.lastBank = null;
            }
            if (this.banks.get((Object)Integer.valueOf((int)bankId)).isPublic) {
                File banksDir = CustomNpcs.getWorldSaveDirectory("banks");
                File fileBank = new File(banksDir, bankId + ".dat");
                if (fileBank.exists()) {
                    Util.instance.removeFile(fileBank);
                }
            } else {
                File datasDir = CustomNpcs.getWorldSaveDirectory("playerdata");
                if (datasDir == null) {
                    return;
                }
                for (File playerDir : Objects.requireNonNull(datasDir.listFiles())) {
                    if (!playerDir.isDirectory()) continue;
                    for (File banksDir : Objects.requireNonNull(playerDir.listFiles())) {
                        File fileBank;
                        if (!banksDir.isDirectory() || !banksDir.getName().equals("banks") || !(fileBank = new File(banksDir, bankId + ".dat")).exists()) continue;
                        Util.instance.removeFile(fileBank);
                    }
                }
            }
        }
        this.banks.remove(bankId);
        this.saveBanks();
    }

    public void saveBank(Bank bank) {
        if (bank.id < 0) {
            bank.id = this.getUnusedId();
        }
        this.banks.put(bank.id, bank);
        this.saveBanks();
    }

    public void saveBanks() {
        CustomNpcs.debugData.start(null);
        try {
            File saveDir = CustomNpcs.getWorldSaveDirectory();
            File file = new File(saveDir, "bank.dat_new");
            File file2 = new File(saveDir, "bank.dat_old");
            File file3 = new File(saveDir, "bank.dat");
            CompressedStreamTools.func_74799_a((NBTTagCompound)this.getNBT(), (OutputStream)Files.newOutputStream(file.toPath(), new OpenOption[0]));
            if (file2.exists()) {
                file2.delete();
            }
            file3.renameTo(file2);
            if (file3.exists()) {
                file3.delete();
            }
            file.renameTo(file3);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            LogWriter.error(e);
        }
        CustomNpcs.debugData.end(null);
    }

    public void update() {
        for (Bank bank : this.banks.values()) {
            if (!bank.hasBankData()) continue;
            bank.getBankData().save();
            if (CustomNpcs.Server == null) continue;
            boolean clear = true;
            for (EntityPlayerMP player : CustomNpcs.Server.func_184103_al().func_181057_v()) {
                if (!(player.field_71070_bA instanceof ContainerNPCBank) || ((ContainerNPCBank)player.field_71070_bA).bank.id != bank.id) continue;
                clear = false;
                break;
            }
            if (!clear) continue;
            bank.clearBankData();
        }
    }
}

